<?php
	// 都道府県コード http://nlftp.mlit.go.jp/ksj/gml/codelist/PrefCd.html
	$pref_ar1 = array(
		'01' => '北海道',
		'02' => '青森県',
		'03' => '岩手県',
		'04' => '宮城県',
		'05' => '秋田県',
		'06' => '山形県',
		'07' => '福島県',
		'08' => '茨城県',
		'09' => '栃木県',
		'10' => '群馬県',
		'11' => '埼玉県',
		'12' => '千葉県',
		'13' => '東京都',
		'14' => '神奈川県',
		'15' => '新潟県',
		'16' => '富山県',
		'17' => '石川県',
		'18' => '福井県',
		'19' => '山梨県',
		'20' => '長野県',
		'21' => '岐阜県',
		'22' => '静岡県',
		'23' => '愛知県',
		'24' => '三重県',
		'25' => '滋賀県',
		'26' => '京都府',
		'27' => '大阪府',
		'28' => '兵庫県',
		'29' => '奈良県',
		'30' => '和歌山県',
		'31' => '鳥取県',
		'32' => '島根県',
		'33' => '岡山県',
		'34' => '広島県',
		'35' => '山口県',
		'36' => '徳島県',
		'37' => '香川県',
		'38' => '愛媛県',
		'39' => '高知県',
		'40' => '福岡県',
		'41' => '佐賀県',
		'42' => '長崎県',
		'43' => '熊本県',
		'44' => '大分県',
		'45' => '宮崎県',
		'46' => '鹿児島県',
		'47' => '沖縄県',
	);

// チェックするフィールドとそのレシピ
/*
チェックするフォールドname | 空欄チェック( true：空はNG / false：空OK ) | チェックタイプ( hankaku：全て半角はNG / numhaifun：半角数字とハイフン以外はNG / num：半角数字以外はNG )
$checkfld = array(
	'name' => array( true, 'hankaku' ),
);
*/
function Field_Security_Check( $checkfld = array() ) {
	$errmsg_ar = array(); $errmsg = ""; $errflg = true;

	if( !count( $checkfld ) ) {
		//return $errmsg;
		return false;
	}

	foreach( $checkfld as $fld => $v ) {
//print "{$fld} => {$v}<br>\n";
		$flddata = Hankaku_Conv( $_POST[$fld] );

		switch( $v[1] ) {
			case "hankaku": // 全て半角はNG
				if( $v[0] ) {
					if( !strlen( $flddata ) ) {
						$errmsg_ar[] = "{$fld}：空欄";
						$errflg = false;
					} else {
						if( strlen( $flddata ) === mb_strlen( $flddata, 'UTF-8' ) ) {
							$errmsg_ar[] = "{$fld}：全て半角はNG [{$flddata}]";
							$errflg = false;
						}
					}
				} else {
					if( strlen( $flddata ) > 0 ) {
						if( strlen( $flddata ) === mb_strlen( $flddata, 'UTF-8' ) ) {
							$errmsg_ar[] = "{$fld}：全て半角はNG [{$flddata}]";
							$errflg = false;
						}
					}
				}
				break;
			case "numhaifun": // 半角数字とハイフン以外はNG
				if( $v[0] ) {
					if( !strlen( $flddata ) ) {
						$errmsg_ar[] = "{$fld}：空欄";
						$errflg = false;
					} else {
						if( preg_match( '/[^0-9\-]/ui', $flddata ) ) {
							$errmsg_ar[] = "{$fld}：半角数字とハイフン以外はNG [{$flddata}]";
							$errflg = false;
						}
					}
				} else {
					if( strlen( $flddata ) > 0 ) {
						if( preg_match( '/[^0-9\-]/ui', $flddata ) ) {
							$errmsg_ar[] = "{$fld}：半角数字とハイフン以外はNG [{$flddata}]";
							$errflg = false;
						}
					}
				}
				break;
			case "num": // 半角数字以外はNG
				if( $v[0] ) {
					if( !strlen( $flddata ) ) {
						$errmsg_ar[] = "{$fld}：空欄";
						$errflg = false;
					} else {
						if( !is_numeric( $flddata ) ) {
							$errmsg_ar[] = "{$fld}：半角数字以外はNG [{$flddata}]";
							$errflg = false;
						}
					}
				} else {
					if( strlen( $flddata ) > 0 ) {
						if( !is_numeric( $flddata ) ) {
							$errmsg_ar[] = "{$fld}：半角数字以外はNG [{$flddata}]";
							$errflg = false;
						}
					}
				}
				break;
			case "numslash": // 半角数字とスラッシュ以外はNG
				if( $v[0] ) {
					if( !strlen( $flddata ) ) {
						$errmsg_ar[] = "{$fld}：空欄";
						$errflg = false;
					} else {
						if( preg_match( '/[^0-9\/]/ui', $flddata ) ) {
							$errmsg_ar[] = "{$fld}：半角数字とスラッシュ以外はNG [{$flddata}]";
							$errflg = false;
						}
					}
				} else {
					if( strlen( $flddata ) > 0 ) {
						if( preg_match( '/[^0-9\/]/ui', $flddata ) ) {
							$errmsg_ar[] = "{$fld}：半角数字とスラッシュ以外はNG [{$flddata}]";
							$errflg = false;
						}
					}
				}
				break;
		}
	}

	if( count( $errmsg_ar ) > 0 ) {
		$errmsg = implode( "<br>", $errmsg_ar );
	}

	//return $errmsg;
	return $errflg;
}
function Hankaku_Conv( $val = Null ) {
	if( strlen( $val ) > 0 ) {
		$val = mb_convert_kana( $val, "as", 'UTF-8' );

		$val = str_replace( array( " ", "　" ), '', $val );

		$val = str_replace( "ー", "-", $val );
		$val = str_replace( "－", "-", $val );
		$val = str_replace( "―", "-", $val );
		$val = str_replace( "‐", "-", $val );
		$val = str_replace( "ｰ", "-", $val );

		$val = str_replace( "＠", "@", $val );

		$val = str_replace( "＿", "_", $val );
		$val = str_replace( "．", ".", $val );
		$val = str_replace( "。", ".", $val );

		$val = str_replace( "、", ".", $val );
		$val = str_replace( "､", ".", $val );
		$val = str_replace( "，", ".", $val );
		$val = str_replace( ",", ".", $val );

		$val = str_replace( "／", "/", $val );
		$val = str_replace( "：", ":", $val );
	}

	return $val;
}
function Mail_Conv( $val = Null ) {
	if( strlen( $val ) > 0 ) {
		$val = mb_convert_kana( $val, "as", 'UTF-8' );

		$val = str_replace( " ", "", $val );

		$val = str_replace( "ー", "-", $val );
		$val = str_replace( "－", "-", $val );
		$val = str_replace( "―", "-", $val );
		$val = str_replace( "‐", "-", $val );
		$val = str_replace( "ｰ", "-", $val );

		$val = str_replace( "＠", "@", $val );

		$val = str_replace( "＿", "_", $val );
		$val = str_replace( "．", ".", $val );
		$val = str_replace( "。", ".", $val );

		$val = str_replace( "、", ".", $val );
		$val = str_replace( "､", ".", $val );
		$val = str_replace( "，", ".", $val );
		$val = str_replace( ",", ".", $val );

		$val = str_replace( "／", "/", $val );
		$val = str_replace( "：", ":", $val );
	}

	return $val;
}
function Get_Dir_Info() {
	// 設定例：echo Get_Dir_Info();

	$file_path = __FILE__;
	$dir_path = __DIR__;

	$path_str = "Dir : {$dir_path}<br>File : {$file_path}<br><br>\n";

	return $path_str;
}
function Write_Log( $sesid = Null, $postdata = Null, $pgtp = Null ) {
	$log_dir = LOG_DIR;

	if( strlen( $log_dir ) > 0 && file_exists( $log_dir ) ) {
		$dirPerms = substr( sprintf( '%o', fileperms( $log_dir ) ), -4 );

		if( $dirPerms == "0777" ) {
			Del_File( $log_dir );

			$nowday = date( "YmdHis" );

			$logfile = "{$log_dir}/log_{$nowday}_{$sesid}_{$pgtp}.txt";
			$data = "{$postdata}\n-------END---------\n";

			file_put_contents( $logfile, $data, FILE_APPEND );

			chmod( $logfile, 0666 );
		}
	}

	//print "{$dirPerms}<br><br>\n";
}
// 30日以上経過しているログファイルを削除
function Del_File( $targetdir = Null ) {
	if( strlen( $targetdir ) > 0 && file_exists( $targetdir ) ) {
		$dirPerms = substr( sprintf( '%o', fileperms( $targetdir ) ), -4 );

		if( $dirPerms == "0777" ) {
			//30日前のUnixタイムスタンプを算出(60秒×60分×24時間×30日：60*60*24*30)
			$hikakudate = time() - ( 60 * 60 * 24 * 30 );

			//対象とするディレクトリ情報をセットして開く
			$targetdir_hd = opendir("{$targetdir}/");

			//存在するファイルの分だけループして情報を取得する
			while( false !== ( $targetfile = readdir( $targetdir_hd ) ) ) {
				if( $targetfile != "." && $targetfile != ".." && $targetfile != ".htaccess" && $targetfile != ".htpasswd" ) {
					$filepath = "{$targetdir}/{$targetfile}";

					if( file_exists( $filepath ) ) {
						//ファイルの最終更新日時をUNIXタイムスタンプで取得
						$filemtime = filemtime( $filepath );

						//30日より前の更新日時だった場合にはファイルをフォルダから削除する
						if( $hikakudate > $filemtime ) {
							unlink( $filepath );
						}
					}
				}
			}
			closedir( $targetdir_hd );
		}
	}
}
?>
